package io.k8s.api.core.v1

/* PodTemplateSpec describes the data a pod should have when created from a template */
import io.circe._
import io.circe.generic.semiauto._

case class PodTemplateSpec(
  /* Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata */
  metadata: Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None,
  /* Specification of the desired behavior of the pod. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status */
  spec: Option[io.k8s.api.core.v1.PodSpec] = None
)

object PodTemplateSpec {
  implicit lazy val encoder: Encoder.AsObject[PodTemplateSpec] = deriveEncoder
  implicit lazy val decoder: Decoder[PodTemplateSpec] = deriveDecoder
}
