package io.k8s.api.core.v1

import io.circe._
import io.circe.generic.semiauto._

case class PortStatus(
  /* Port is the port number of the service port of which status is recorded here */
  port: Int,
  /* Protocol is the protocol of the service port of which status is recorded here The supported values are: "TCP", "UDP", "SCTP" */
  protocol: String,
  /* Error is to record the problem with the service port The format of the error shall comply with the following rules: - built-in error values shall be specified in this file and those shall use
    CamelCase names
  - cloud provider specific error values must have names that comply with the
    format foo.example.com/CamelCase. */
  error: Option[String] = None
)

object PortStatus {
  implicit lazy val encoder: Encoder.AsObject[PortStatus] = deriveEncoder
  implicit lazy val decoder: Decoder[PortStatus] = deriveDecoder
}
