package io.k8s.apimachinery.pkg.apis.meta.v1

/* Preconditions must be fulfilled before an operation (update, delete, etc.) is carried out. */
import io.circe._
import io.circe.generic.semiauto._

case class Preconditions(
  /* Specifies the target ResourceVersion */
  resourceVersion: Option[String] = None,
  /* Specifies the target UID. */
  uid: Option[String] = None
)

object Preconditions {
  implicit lazy val encoder: Encoder.AsObject[Preconditions] = deriveEncoder
  implicit lazy val decoder: Decoder[Preconditions] = deriveDecoder
}
