package io.k8s.api.core.v1

/* An empty preferred scheduling term matches all objects with implicit weight 0 (i.e. it's a no-op). A null preferred scheduling term matches no objects (i.e. is also a no-op). */
import io.circe._
import io.circe.generic.semiauto._

case class PreferredSchedulingTerm(
  /* Weight associated with matching the corresponding nodeSelectorTerm, in the range 1-100. */
  weight: Int,
  /* A node selector term, associated with the corresponding weight. */
  preference: io.k8s.api.core.v1.NodeSelectorTerm
)

object PreferredSchedulingTerm {
  implicit lazy val encoder: Encoder.AsObject[PreferredSchedulingTerm] = deriveEncoder
  implicit lazy val decoder: Decoder[PreferredSchedulingTerm] = deriveDecoder
}
