package io.k8s.api.core.v1

/* Probe describes a health check to be performed against a container to determine whether it is alive or ready to receive traffic. */
import io.circe._
import io.circe.generic.semiauto._

case class Probe(
  /* One and only one of the following should be specified. Exec specifies the action to take. */
  exec: Option[io.k8s.api.core.v1.ExecAction] = None,
  /* Minimum consecutive failures for the probe to be considered failed after having succeeded. Defaults to 3. Minimum value is 1. */
  failureThreshold: Option[Int] = None,
  /* HTTPGet specifies the http request to perform. */
  httpGet: Option[io.k8s.api.core.v1.HTTPGetAction] = None,
  /* Number of seconds after the container has started before liveness probes are initiated. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes */
  initialDelaySeconds: Option[Int] = None,
  /* How often (in seconds) to perform the probe. Default to 10 seconds. Minimum value is 1. */
  periodSeconds: Option[Int] = None,
  /* Minimum consecutive successes for the probe to be considered successful after having failed. Defaults to 1. Must be 1 for liveness and startup. Minimum value is 1. */
  successThreshold: Option[Int] = None,
  /* TCPSocket specifies an action involving a TCP port. TCP hooks not yet supported */
  tcpSocket: Option[io.k8s.api.core.v1.TCPSocketAction] = None,
  /* Optional duration in seconds the pod needs to terminate gracefully upon probe failure. The grace period is the duration in seconds after the processes running in the pod are sent a termination signal and the time when the processes are forcibly halted with a kill signal. Set this value longer than the expected cleanup time for your process. If this value is nil, the pod's terminationGracePeriodSeconds will be used. Otherwise, this value overrides the value provided by the pod spec. Value must be non-negative integer. The value zero indicates stop immediately via the kill signal (no opportunity to shut down). This is an alpha field and requires enabling ProbeTerminationGracePeriod feature gate. */
  terminationGracePeriodSeconds: Option[Long] = None,
  /* Number of seconds after which the probe times out. Defaults to 1 second. Minimum value is 1. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes */
  timeoutSeconds: Option[Int] = None
)

object Probe {
  implicit lazy val encoder: Encoder.AsObject[Probe] = deriveEncoder
  implicit lazy val decoder: Decoder[Probe] = deriveDecoder
}
