package io.k8s.api.core.v1

/* Represents a projected volume source */
import io.circe._
import io.circe.generic.semiauto._

case class ProjectedVolumeSource(
  /* Mode bits used to set permissions on created files by default. Must be an octal value between 0000 and 0777 or a decimal value between 0 and 511. YAML accepts both octal and decimal values, JSON requires decimal values for mode bits. Directories within the path are not affected by this setting. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set. */
  defaultMode: Option[Int] = None,
  /* list of volume projections */
  sources: Option[Seq[io.k8s.api.core.v1.VolumeProjection]] = None
)

object ProjectedVolumeSource {
  implicit lazy val encoder: Encoder.AsObject[ProjectedVolumeSource] = deriveEncoder
  implicit lazy val decoder: Decoder[ProjectedVolumeSource] = deriveDecoder
}
