package io.k8s.api.core.v1

/* Represents a Quobyte mount that lasts the lifetime of a pod. Quobyte volumes do not support ownership management or SELinux relabeling. */
import io.circe._
import io.circe.generic.semiauto._

case class QuobyteVolumeSource(
  /* Registry represents a single or multiple Quobyte Registry services specified as a string as host:port pair (multiple entries are separated with commas) which acts as the central registry for volumes */
  registry: String,
  /* Volume is a string that references an already created Quobyte volume by name. */
  volume: String,
  /* Group to map volume access to Default is no group */
  group: Option[String] = None,
  /* ReadOnly here will force the Quobyte volume to be mounted with read-only permissions. Defaults to false. */
  readOnly: Option[Boolean] = None,
  /* Tenant owning the given Quobyte volume in the Backend Used with dynamically provisioned Quobyte volumes, value is set by the plugin */
  tenant: Option[String] = None,
  /* User to map volume access to Defaults to serivceaccount user */
  user: Option[String] = None
)

object QuobyteVolumeSource {
  implicit lazy val encoder: Encoder.AsObject[QuobyteVolumeSource] = deriveEncoder
  implicit lazy val decoder: Decoder[QuobyteVolumeSource] = deriveDecoder
}
