package io.k8s.api.apps.v1

/* ReplicaSetCondition describes the state of a replica set at a certain point. */
import io.circe._
import io.circe.generic.semiauto._

case class ReplicaSetCondition(
  /* Type of replica set condition. */
  `type`: String,
  /* Status of the condition, one of True, False, Unknown. */
  status: String,
  /* The last time the condition transitioned from one status to another. */
  lastTransitionTime: Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time] = None,
  /* A human readable message indicating details about the transition. */
  message: Option[String] = None,
  /* The reason for the condition's last transition. */
  reason: Option[String] = None
)

object ReplicaSetCondition {
  implicit lazy val encoder: Encoder.AsObject[ReplicaSetCondition] = deriveEncoder
  implicit lazy val decoder: Decoder[ReplicaSetCondition] = deriveDecoder
}
