package io.k8s.api.core.v1

/* ReplicationControllerStatus represents the current status of a replication controller. */
import io.circe._
import io.circe.generic.semiauto._

case class ReplicationControllerStatus(
  /* Replicas is the most recently oberved number of replicas. More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller#what-is-a-replicationcontroller */
  replicas: Int,
  /* The number of available replicas (ready for at least minReadySeconds) for this replication controller. */
  availableReplicas: Option[Int] = None,
  /* Represents the latest available observations of a replication controller's current state. */
  conditions: Option[Seq[io.k8s.api.core.v1.ReplicationControllerCondition]] = None,
  /* The number of pods that have labels matching the labels of the pod template of the replication controller. */
  fullyLabeledReplicas: Option[Int] = None,
  /* ObservedGeneration reflects the generation of the most recently observed replication controller. */
  observedGeneration: Option[Long] = None,
  /* The number of ready replicas for this replication controller. */
  readyReplicas: Option[Int] = None
)

object ReplicationControllerStatus {
  implicit lazy val encoder: Encoder.AsObject[ReplicationControllerStatus] = deriveEncoder
  implicit lazy val decoder: Decoder[ReplicationControllerStatus] = deriveDecoder
}
