package io.k8s.api.core.v1

/* ResourceQuotaList is a list of ResourceQuota items. */
import io.circe._
import io.circe.generic.semiauto._

case class ResourceQuotaList(
  /* Items is a list of ResourceQuota objects. More info: https://kubernetes.io/docs/concepts/policy/resource-quotas/ */
  items: Seq[io.k8s.api.core.v1.ResourceQuota],
  /* APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources */
  apiVersion: Option[String] = None,
  /* Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds */
  kind: Option[String] = None,
  /* Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds */
  metadata: Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta] = None
)

object ResourceQuotaList {
  implicit lazy val encoder: Encoder.AsObject[ResourceQuotaList] = deriveEncoder
  implicit lazy val decoder: Decoder[ResourceQuotaList] = deriveDecoder
}
