package io.k8s.api.core.v1

/* ResourceRequirements describes the compute resource requirements. */
import io.circe._
import io.circe.generic.semiauto._

case class ResourceRequirements(
  /* Limits describes the maximum amount of compute resources allowed. More info: https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/ */
  limits: Option[Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity]] = None,
  /* Requests describes the minimum amount of compute resources required. If Requests is omitted for a container, it defaults to Limits if that is explicitly specified, otherwise to an implementation-defined value. More info: https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/ */
  requests: Option[Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity]] = None
)

object ResourceRequirements {
  implicit lazy val encoder: Encoder.AsObject[ResourceRequirements] = deriveEncoder
  implicit lazy val decoder: Decoder[ResourceRequirements] = deriveDecoder
}
