package io.k8s.api.rbac.v1alpha1

/* Role is a namespaced, logical grouping of PolicyRules that can be referenced as a unit by a RoleBinding. Deprecated in v1.17 in favor of rbac.authorization.k8s.io/v1 Role, and will no longer be served in v1.22. */
import io.circe._
import io.circe.generic.semiauto._

case class Role(
  /* APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources */
  apiVersion: Option[String] = None,
  /* Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds */
  kind: Option[String] = None,
  /* Standard object's metadata. */
  metadata: Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None,
  /* Rules holds all the PolicyRules for this Role */
  rules: Option[Seq[io.k8s.api.rbac.v1alpha1.PolicyRule]] = None
)

object Role {
  implicit lazy val encoder: Encoder.AsObject[Role] = deriveEncoder
  implicit lazy val decoder: Decoder[Role] = deriveDecoder
}
