package io.k8s.api.rbac.v1alpha1

/* RoleBinding references a role, but does not contain it.  It can reference a Role in the same namespace or a ClusterRole in the global namespace. It adds who information via Subjects and namespace information by which namespace it exists in.  RoleBindings in a given namespace only have effect in that namespace. Deprecated in v1.17 in favor of rbac.authorization.k8s.io/v1 RoleBinding, and will no longer be served in v1.22. */
import io.circe._
import io.circe.generic.semiauto._

case class RoleBinding(
  /* RoleRef can reference a Role in the current namespace or a ClusterRole in the global namespace. If the RoleRef cannot be resolved, the Authorizer must return an error. */
  roleRef: io.k8s.api.rbac.v1alpha1.RoleRef,
  /* APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources */
  apiVersion: Option[String] = None,
  /* Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds */
  kind: Option[String] = None,
  /* Standard object's metadata. */
  metadata: Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None,
  /* Subjects holds references to the objects the role applies to. */
  subjects: Option[Seq[io.k8s.api.rbac.v1alpha1.Subject]] = None
)

object RoleBinding {
  implicit lazy val encoder: Encoder.AsObject[RoleBinding] = deriveEncoder
  implicit lazy val decoder: Decoder[RoleBinding] = deriveDecoder
}
