package io.k8s.api.policy.v1beta1

/* RunAsGroupStrategyOptions defines the strategy type and any options used to create the strategy. */
import io.circe._
import io.circe.generic.semiauto._

case class RunAsGroupStrategyOptions(
  /* rule is the strategy that will dictate the allowable RunAsGroup values that may be set. */
  rule: String,
  /* ranges are the allowed ranges of gids that may be used. If you would like to force a single gid then supply a single range with the same start and end. Required for MustRunAs. */
  ranges: Option[Seq[io.k8s.api.policy.v1beta1.IDRange]] = None
)

object RunAsGroupStrategyOptions {
  implicit lazy val encoder: Encoder.AsObject[RunAsGroupStrategyOptions] = deriveEncoder
  implicit lazy val decoder: Decoder[RunAsGroupStrategyOptions] = deriveDecoder
}
