package io.k8s.api.policy.v1beta1

/* RuntimeClassStrategyOptions define the strategy that will dictate the allowable RuntimeClasses for a pod. */
import io.circe._
import io.circe.generic.semiauto._

case class RuntimeClassStrategyOptions(
  /* allowedRuntimeClassNames is an allowlist of RuntimeClass names that may be specified on a pod. A value of "*" means that any RuntimeClass name is allowed, and must be the only item in the list. An empty list requires the RuntimeClassName field to be unset. */
  allowedRuntimeClassNames: Seq[String],
  /* defaultRuntimeClassName is the default RuntimeClassName to set on the pod. The default MUST be allowed by the allowedRuntimeClassNames list. A value of nil does not mutate the Pod. */
  defaultRuntimeClassName: Option[String] = None
)

object RuntimeClassStrategyOptions {
  implicit lazy val encoder: Encoder.AsObject[RuntimeClassStrategyOptions] = deriveEncoder
  implicit lazy val decoder: Decoder[RuntimeClassStrategyOptions] = deriveDecoder
}
