package io.k8s.api.policy.v1beta1

/* SELinuxStrategyOptions defines the strategy type and any options used to create the strategy. */
import io.circe._
import io.circe.generic.semiauto._

case class SELinuxStrategyOptions(
  /* rule is the strategy that will dictate the allowable labels that may be set. */
  rule: String,
  /* seLinuxOptions required to run as; required for MustRunAs More info: https://kubernetes.io/docs/tasks/configure-pod-container/security-context/ */
  seLinuxOptions: Option[io.k8s.api.core.v1.SELinuxOptions] = None
)

object SELinuxStrategyOptions {
  implicit lazy val encoder: Encoder.AsObject[SELinuxStrategyOptions] = deriveEncoder
  implicit lazy val decoder: Decoder[SELinuxStrategyOptions] = deriveDecoder
}
