package io.k8s.api.autoscaling.v1

/* Scale represents a scaling request for a resource. */
import io.circe._
import io.circe.generic.semiauto._

case class Scale(
  /* APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources */
  apiVersion: Option[String] = None,
  /* Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds */
  kind: Option[String] = None,
  /* Standard object metadata; More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata. */
  metadata: Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None,
  /* defines the behavior of the scale. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status. */
  spec: Option[io.k8s.api.autoscaling.v1.ScaleSpec] = None,
  /* current status of the scale. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status. Read-only. */
  status: Option[io.k8s.api.autoscaling.v1.ScaleStatus] = None
)

object Scale {
  implicit lazy val encoder: Encoder.AsObject[Scale] = deriveEncoder
  implicit lazy val decoder: Decoder[Scale] = deriveDecoder
}
