package io.k8s.api.core.v1

/* ScaleIOPersistentVolumeSource represents a persistent ScaleIO volume */
import io.circe._
import io.circe.generic.semiauto._

case class ScaleIOPersistentVolumeSource(
  /* The host address of the ScaleIO API Gateway. */
  gateway: String,
  /* The name of the storage system as configured in ScaleIO. */
  system: String,
  /* SecretRef references to the secret for ScaleIO user and other sensitive information. If this is not provided, Login operation will fail. */
  secretRef: io.k8s.api.core.v1.SecretReference,
  /* Filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs". Default is "xfs" */
  fsType: Option[String] = None,
  /* The name of the ScaleIO Protection Domain for the configured storage. */
  protectionDomain: Option[String] = None,
  /* Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts. */
  readOnly: Option[Boolean] = None,
  /* Flag to enable/disable SSL communication with Gateway, default false */
  sslEnabled: Option[Boolean] = None,
  /* Indicates whether the storage for a volume should be ThickProvisioned or ThinProvisioned. Default is ThinProvisioned. */
  storageMode: Option[String] = None,
  /* The ScaleIO Storage Pool associated with the protection domain. */
  storagePool: Option[String] = None,
  /* The name of a volume already created in the ScaleIO system that is associated with this volume source. */
  volumeName: Option[String] = None
)

object ScaleIOPersistentVolumeSource {
  implicit lazy val encoder: Encoder.AsObject[ScaleIOPersistentVolumeSource] = deriveEncoder
  implicit lazy val decoder: Decoder[ScaleIOPersistentVolumeSource] = deriveDecoder
}
