package io.k8s.api.core.v1

/* SecretKeySelector selects a key of a Secret. */
import io.circe._
import io.circe.generic.semiauto._

case class SecretKeySelector(
  /* The key of the secret to select from.  Must be a valid secret key. */
  key: String,
  /* Name of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names */
  name: Option[String] = None,
  /* Specify whether the Secret or its key must be defined */
  optional: Option[Boolean] = None
)

object SecretKeySelector {
  implicit lazy val encoder: Encoder.AsObject[SecretKeySelector] = deriveEncoder
  implicit lazy val decoder: Decoder[SecretKeySelector] = deriveDecoder
}
