package io.k8s.api.core.v1

/* SecretReference represents a Secret Reference. It has enough information to retrieve secret in any namespace */
import io.circe._
import io.circe.generic.semiauto._

case class SecretReference(
  /* Name is unique within a namespace to reference a secret resource. */
  name: Option[String] = None,
  /* Namespace defines the space within which the secret name must be unique. */
  namespace: Option[String] = None
)

object SecretReference {
  implicit lazy val encoder: Encoder.AsObject[SecretReference] = deriveEncoder
  implicit lazy val decoder: Decoder[SecretReference] = deriveDecoder
}
