package io.k8s.apimachinery.pkg.apis.meta.v1

/* ServerAddressByClientCIDR helps the client to determine the server address that they should use, depending on the clientCIDR that they match. */
import io.circe._
import io.circe.generic.semiauto._

case class ServerAddressByClientCIDR(
  /* The CIDR with which clients can match their IP to figure out the server address that they should use. */
  clientCIDR: String,
  /* Address of this server, suitable for a client that matches the above CIDR. This can be a hostname, hostname:port, IP or IP:port. */
  serverAddress: String
)

object ServerAddressByClientCIDR {
  implicit lazy val encoder: Encoder.AsObject[ServerAddressByClientCIDR] = deriveEncoder
  implicit lazy val decoder: Decoder[ServerAddressByClientCIDR] = deriveDecoder
}
