package io.k8s.api.networking.v1

/* ServiceBackendPort is the service port being referenced. */
import io.circe._
import io.circe.generic.semiauto._

case class ServiceBackendPort(
  /* Name is the name of the port on the Service. This is a mutually exclusive setting with "Number". */
  name: Option[String] = None,
  /* Number is the numerical port number (e.g. 80) on the Service. This is a mutually exclusive setting with "Name". */
  number: Option[Int] = None
)

object ServiceBackendPort {
  implicit lazy val encoder: Encoder.AsObject[ServiceBackendPort] = deriveEncoder
  implicit lazy val decoder: Decoder[ServiceBackendPort] = deriveDecoder
}
