package io.k8s.api.core.v1

/* SessionAffinityConfig represents the configurations of session affinity. */
import io.circe._
import io.circe.generic.semiauto._

case class SessionAffinityConfig(
  /* clientIP contains the configurations of Client IP based session affinity. */
  clientIP: Option[io.k8s.api.core.v1.ClientIPConfig] = None
)

object SessionAffinityConfig {
  implicit lazy val encoder: Encoder.AsObject[SessionAffinityConfig] = deriveEncoder
  implicit lazy val decoder: Decoder[SessionAffinityConfig] = deriveDecoder
}
