package io.k8s.api.apps.v1

/* StatefulSetStatus represents the current state of a StatefulSet. */
import io.circe._
import io.circe.generic.semiauto._

case class StatefulSetStatus(
  /* replicas is the number of Pods created by the StatefulSet controller. */
  replicas: Int,
  /* collisionCount is the count of hash collisions for the StatefulSet. The StatefulSet controller uses this field as a collision avoidance mechanism when it needs to create the name for the newest ControllerRevision. */
  collisionCount: Option[Int] = None,
  /* Represents the latest available observations of a statefulset's current state. */
  conditions: Option[Seq[io.k8s.api.apps.v1.StatefulSetCondition]] = None,
  /* currentReplicas is the number of Pods created by the StatefulSet controller from the StatefulSet version indicated by currentRevision. */
  currentReplicas: Option[Int] = None,
  /* currentRevision, if not empty, indicates the version of the StatefulSet used to generate Pods in the sequence [0,currentReplicas). */
  currentRevision: Option[String] = None,
  /* observedGeneration is the most recent generation observed for this StatefulSet. It corresponds to the StatefulSet's generation, which is updated on mutation by the API Server. */
  observedGeneration: Option[Long] = None,
  /* readyReplicas is the number of Pods created by the StatefulSet controller that have a Ready Condition. */
  readyReplicas: Option[Int] = None,
  /* updateRevision, if not empty, indicates the version of the StatefulSet used to generate Pods in the sequence [replicas-updatedReplicas,replicas) */
  updateRevision: Option[String] = None,
  /* updatedReplicas is the number of Pods created by the StatefulSet controller from the StatefulSet version indicated by updateRevision. */
  updatedReplicas: Option[Int] = None
)

object StatefulSetStatus {
  implicit lazy val encoder: Encoder.AsObject[StatefulSetStatus] = deriveEncoder
  implicit lazy val decoder: Decoder[StatefulSetStatus] = deriveDecoder
}
