package io.k8s.api.apps.v1

/* StatefulSetUpdateStrategy indicates the strategy that the StatefulSet controller will use to perform updates. It includes any additional parameters necessary to perform the update for the indicated strategy. */
import io.circe._
import io.circe.generic.semiauto._

case class StatefulSetUpdateStrategy(
  /* RollingUpdate is used to communicate parameters when Type is RollingUpdateStatefulSetStrategyType. */
  rollingUpdate: Option[io.k8s.api.apps.v1.RollingUpdateStatefulSetStrategy] = None,
  /* Type indicates the type of the StatefulSetUpdateStrategy. Default is RollingUpdate. */
  `type`: Option[String] = None
)

object StatefulSetUpdateStrategy {
  implicit lazy val encoder: Encoder.AsObject[StatefulSetUpdateStrategy] = deriveEncoder
  implicit lazy val decoder: Decoder[StatefulSetUpdateStrategy] = deriveDecoder
}
