package io.k8s.api.rbac.v1

/* Subject contains a reference to the object or user identities a role binding applies to.  This can either hold a direct API object reference, or a value for non-objects such as user and group names. */
import io.circe._
import io.circe.generic.semiauto._

case class Subject(
  /* Kind of object being referenced. Values defined by this API group are "User", "Group", and "ServiceAccount". If the Authorizer does not recognized the kind value, the Authorizer should report an error. */
  kind: String,
  /* Name of the object being referenced. */
  name: String,
  /* APIGroup holds the API group of the referenced subject. Defaults to "" for ServiceAccount subjects. Defaults to "rbac.authorization.k8s.io" for User and Group subjects. */
  apiGroup: Option[String] = None,
  /* Namespace of the referenced object.  If the object kind is non-namespace, such as "User" or "Group", and this value is not empty the Authorizer should report an error. */
  namespace: Option[String] = None
)

object Subject {
  implicit lazy val encoder: Encoder.AsObject[Subject] = deriveEncoder
  implicit lazy val decoder: Decoder[Subject] = deriveDecoder
}
