package io.k8s.api.policy.v1beta1

/* SupplementalGroupsStrategyOptions defines the strategy type and options used to create the strategy. */
import io.circe._
import io.circe.generic.semiauto._

case class SupplementalGroupsStrategyOptions(
  /* ranges are the allowed ranges of supplemental groups.  If you would like to force a single supplemental group then supply a single range with the same start and end. Required for MustRunAs. */
  ranges: Option[Seq[io.k8s.api.policy.v1beta1.IDRange]] = None,
  /* rule is the strategy that will dictate what supplemental groups is used in the SecurityContext. */
  rule: Option[String] = None
)

object SupplementalGroupsStrategyOptions {
  implicit lazy val encoder: Encoder.AsObject[SupplementalGroupsStrategyOptions] = deriveEncoder
  implicit lazy val decoder: Decoder[SupplementalGroupsStrategyOptions] = deriveDecoder
}
