package io.k8s.api.storage.v1beta1

/* TokenRequest contains parameters of a service account token. */
import io.circe._
import io.circe.generic.semiauto._

case class TokenRequest(
  /* Audience is the intended audience of the token in "TokenRequestSpec". It will default to the audiences of kube apiserver. */
  audience: String,
  /* ExpirationSeconds is the duration of validity of the token in "TokenRequestSpec". It has the same default value of "ExpirationSeconds" in "TokenRequestSpec" */
  expirationSeconds: Option[Long] = None
)

object TokenRequest {
  implicit lazy val encoder: Encoder.AsObject[TokenRequest] = deriveEncoder
  implicit lazy val decoder: Decoder[TokenRequest] = deriveDecoder
}
