package io.k8s.api.core.v1

/* Volume represents a named volume in a pod that may be accessed by any container in the pod. */
import io.circe._
import io.circe.generic.semiauto._

case class Volume(
  /* Volume's name. Must be a DNS_LABEL and unique within the pod. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names */
  name: String,
  /* AWSElasticBlockStore represents an AWS Disk resource that is attached to a kubelet's host machine and then exposed to the pod. More info: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore */
  awsElasticBlockStore: Option[io.k8s.api.core.v1.AWSElasticBlockStoreVolumeSource] = None,
  /* AzureDisk represents an Azure Data Disk mount on the host and bind mount to the pod. */
  azureDisk: Option[io.k8s.api.core.v1.AzureDiskVolumeSource] = None,
  /* AzureFile represents an Azure File Service mount on the host and bind mount to the pod. */
  azureFile: Option[io.k8s.api.core.v1.AzureFileVolumeSource] = None,
  /* CephFS represents a Ceph FS mount on the host that shares a pod's lifetime */
  cephfs: Option[io.k8s.api.core.v1.CephFSVolumeSource] = None,
  /* Cinder represents a cinder volume attached and mounted on kubelets host machine. More info: https://examples.k8s.io/mysql-cinder-pd/README.md */
  cinder: Option[io.k8s.api.core.v1.CinderVolumeSource] = None,
  /* ConfigMap represents a configMap that should populate this volume */
  configMap: Option[io.k8s.api.core.v1.ConfigMapVolumeSource] = None,
  /* CSI (Container Storage Interface) represents ephemeral storage that is handled by certain external CSI drivers (Beta feature). */
  csi: Option[io.k8s.api.core.v1.CSIVolumeSource] = None,
  /* DownwardAPI represents downward API about the pod that should populate this volume */
  downwardAPI: Option[io.k8s.api.core.v1.DownwardAPIVolumeSource] = None,
  /* EmptyDir represents a temporary directory that shares a pod's lifetime. More info: https://kubernetes.io/docs/concepts/storage/volumes#emptydir */
  emptyDir: Option[io.k8s.api.core.v1.EmptyDirVolumeSource] = None,
  /* Ephemeral represents a volume that is handled by a cluster storage driver. The volume's lifecycle is tied to the pod that defines it - it will be created before the pod starts, and deleted when the pod is removed.
  
  Use this if: a) the volume is only needed while the pod runs, b) features of normal volumes like restoring from snapshot or capacity
     tracking are needed,
  c) the storage driver is specified through a storage class, and d) the storage driver supports dynamic volume provisioning through
     a PersistentVolumeClaim (see EphemeralVolumeSource for more
     information on the connection between this volume type
     and PersistentVolumeClaim).
  
  Use PersistentVolumeClaim or one of the vendor-specific APIs for volumes that persist for longer than the lifecycle of an individual pod.
  
  Use CSI for light-weight local ephemeral volumes if the CSI driver is meant to be used that way - see the documentation of the driver for more information.
  
  A pod can use both types of ephemeral volumes and persistent volumes at the same time.
  
  This is a beta feature and only available when the GenericEphemeralVolume feature gate is enabled. */
  ephemeral: Option[io.k8s.api.core.v1.EphemeralVolumeSource] = None,
  /* FC represents a Fibre Channel resource that is attached to a kubelet's host machine and then exposed to the pod. */
  fc: Option[io.k8s.api.core.v1.FCVolumeSource] = None,
  /* FlexVolume represents a generic volume resource that is provisioned/attached using an exec based plugin. */
  flexVolume: Option[io.k8s.api.core.v1.FlexVolumeSource] = None,
  /* Flocker represents a Flocker volume attached to a kubelet's host machine. This depends on the Flocker control service being running */
  flocker: Option[io.k8s.api.core.v1.FlockerVolumeSource] = None,
  /* GCEPersistentDisk represents a GCE Disk resource that is attached to a kubelet's host machine and then exposed to the pod. More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk */
  gcePersistentDisk: Option[io.k8s.api.core.v1.GCEPersistentDiskVolumeSource] = None,
  /* GitRepo represents a git repository at a particular revision. DEPRECATED: GitRepo is deprecated. To provision a container with a git repo, mount an EmptyDir into an InitContainer that clones the repo using git, then mount the EmptyDir into the Pod's container. */
  gitRepo: Option[io.k8s.api.core.v1.GitRepoVolumeSource] = None,
  /* Glusterfs represents a Glusterfs mount on the host that shares a pod's lifetime. More info: https://examples.k8s.io/volumes/glusterfs/README.md */
  glusterfs: Option[io.k8s.api.core.v1.GlusterfsVolumeSource] = None,
  /* HostPath represents a pre-existing file or directory on the host machine that is directly exposed to the container. This is generally used for system agents or other privileged things that are allowed to see the host machine. Most containers will NOT need this. More info: https://kubernetes.io/docs/concepts/storage/volumes#hostpath */
  hostPath: Option[io.k8s.api.core.v1.HostPathVolumeSource] = None,
  /* ISCSI represents an ISCSI Disk resource that is attached to a kubelet's host machine and then exposed to the pod. More info: https://examples.k8s.io/volumes/iscsi/README.md */
  iscsi: Option[io.k8s.api.core.v1.ISCSIVolumeSource] = None,
  /* NFS represents an NFS mount on the host that shares a pod's lifetime More info: https://kubernetes.io/docs/concepts/storage/volumes#nfs */
  nfs: Option[io.k8s.api.core.v1.NFSVolumeSource] = None,
  /* PersistentVolumeClaimVolumeSource represents a reference to a PersistentVolumeClaim in the same namespace. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#persistentvolumeclaims */
  persistentVolumeClaim: Option[io.k8s.api.core.v1.PersistentVolumeClaimVolumeSource] = None,
  /* PhotonPersistentDisk represents a PhotonController persistent disk attached and mounted on kubelets host machine */
  photonPersistentDisk: Option[io.k8s.api.core.v1.PhotonPersistentDiskVolumeSource] = None,
  /* PortworxVolume represents a portworx volume attached and mounted on kubelets host machine */
  portworxVolume: Option[io.k8s.api.core.v1.PortworxVolumeSource] = None,
  /* Items for all in one resources secrets, configmaps, and downward API */
  projected: Option[io.k8s.api.core.v1.ProjectedVolumeSource] = None,
  /* Quobyte represents a Quobyte mount on the host that shares a pod's lifetime */
  quobyte: Option[io.k8s.api.core.v1.QuobyteVolumeSource] = None,
  /* RBD represents a Rados Block Device mount on the host that shares a pod's lifetime. More info: https://examples.k8s.io/volumes/rbd/README.md */
  rbd: Option[io.k8s.api.core.v1.RBDVolumeSource] = None,
  /* ScaleIO represents a ScaleIO persistent volume attached and mounted on Kubernetes nodes. */
  scaleIO: Option[io.k8s.api.core.v1.ScaleIOVolumeSource] = None,
  /* Secret represents a secret that should populate this volume. More info: https://kubernetes.io/docs/concepts/storage/volumes#secret */
  secret: Option[io.k8s.api.core.v1.SecretVolumeSource] = None,
  /* StorageOS represents a StorageOS volume attached and mounted on Kubernetes nodes. */
  storageos: Option[io.k8s.api.core.v1.StorageOSVolumeSource] = None,
  /* VsphereVolume represents a vSphere volume attached and mounted on kubelets host machine */
  vsphereVolume: Option[io.k8s.api.core.v1.VsphereVirtualDiskVolumeSource] = None
)

object Volume {
  implicit lazy val encoder: Encoder.AsObject[Volume] = deriveEncoder
  implicit lazy val decoder: Decoder[Volume] = deriveDecoder
}
