package io.k8s.api.core.v1

/* volumeDevice describes a mapping of a raw block device within a container. */
import io.circe._
import io.circe.generic.semiauto._

case class VolumeDevice(
  /* name must match the name of a persistentVolumeClaim in the pod */
  name: String,
  /* devicePath is the path inside of the container that the device will be mapped to. */
  devicePath: String
)

object VolumeDevice {
  implicit lazy val encoder: Encoder.AsObject[VolumeDevice] = deriveEncoder
  implicit lazy val decoder: Decoder[VolumeDevice] = deriveDecoder
}
