package io.k8s.api.storage.v1

/* VolumeError captures an error encountered during a volume operation. */
import io.circe._
import io.circe.generic.semiauto._

case class VolumeError(
  /* String detailing the error encountered during Attach or Detach operation. This string may be logged, so it should not contain sensitive information. */
  message: Option[String] = None,
  /* Time the error was encountered. */
  time: Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time] = None
)

object VolumeError {
  implicit lazy val encoder: Encoder.AsObject[VolumeError] = deriveEncoder
  implicit lazy val decoder: Decoder[VolumeError] = deriveDecoder
}
