package io.k8s.api.core.v1

/* VolumeMount describes a mounting of a Volume within a container. */
import io.circe._
import io.circe.generic.semiauto._

case class VolumeMount(
  /* This must match the Name of a Volume. */
  name: String,
  /* Path within the container at which the volume should be mounted.  Must not contain ':'. */
  mountPath: String,
  /* mountPropagation determines how mounts are propagated from the host to container and the other way around. When not set, MountPropagationNone is used. This field is beta in 1.10. */
  mountPropagation: Option[String] = None,
  /* Mounted read-only if true, read-write otherwise (false or unspecified). Defaults to false. */
  readOnly: Option[Boolean] = None,
  /* Path within the volume from which the container's volume should be mounted. Defaults to "" (volume's root). */
  subPath: Option[String] = None,
  /* Expanded path within the volume from which the container's volume should be mounted. Behaves similarly to SubPath but environment variable references $(VAR_NAME) are expanded using the container's environment. Defaults to "" (volume's root). SubPathExpr and SubPath are mutually exclusive. */
  subPathExpr: Option[String] = None
)

object VolumeMount {
  implicit lazy val encoder: Encoder.AsObject[VolumeMount] = deriveEncoder
  implicit lazy val decoder: Decoder[VolumeMount] = deriveDecoder
}
