package io.k8s.api.core.v1

/* VolumeNodeAffinity defines constraints that limit what nodes this volume can be accessed from. */
import io.circe._
import io.circe.generic.semiauto._

case class VolumeNodeAffinity(
  /* Required specifies hard node constraints that must be met. */
  required: Option[io.k8s.api.core.v1.NodeSelector] = None
)

object VolumeNodeAffinity {
  implicit lazy val encoder: Encoder.AsObject[VolumeNodeAffinity] = deriveEncoder
  implicit lazy val decoder: Decoder[VolumeNodeAffinity] = deriveDecoder
}
