package io.k8s.api.core.v1

/* Projection that may be projected along with other supported volume types */
import io.circe._
import io.circe.generic.semiauto._

case class VolumeProjection(
  /* information about the configMap data to project */
  configMap: Option[io.k8s.api.core.v1.ConfigMapProjection] = None,
  /* information about the downwardAPI data to project */
  downwardAPI: Option[io.k8s.api.core.v1.DownwardAPIProjection] = None,
  /* information about the secret data to project */
  secret: Option[io.k8s.api.core.v1.SecretProjection] = None,
  /* information about the serviceAccountToken data to project */
  serviceAccountToken: Option[io.k8s.api.core.v1.ServiceAccountTokenProjection] = None
)

object VolumeProjection {
  implicit lazy val encoder: Encoder.AsObject[VolumeProjection] = deriveEncoder
  implicit lazy val decoder: Decoder[VolumeProjection] = deriveDecoder
}
