package io.k8s.api.core.v1

/* Represents a vSphere volume resource. */
import io.circe._
import io.circe.generic.semiauto._

case class VsphereVirtualDiskVolumeSource(
  /* Path that identifies vSphere volume vmdk */
  volumePath: String,
  /* Filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified. */
  fsType: Option[String] = None,
  /* Storage Policy Based Management (SPBM) profile ID associated with the StoragePolicyName. */
  storagePolicyID: Option[String] = None,
  /* Storage Policy Based Management (SPBM) profile name. */
  storagePolicyName: Option[String] = None
)

object VsphereVirtualDiskVolumeSource {
  implicit lazy val encoder: Encoder.AsObject[VsphereVirtualDiskVolumeSource] = deriveEncoder
  implicit lazy val decoder: Decoder[VsphereVirtualDiskVolumeSource] = deriveDecoder
}
