package io.k8s.api.core.v1

/* WindowsSecurityContextOptions contain Windows-specific options and credentials. */
import io.circe._
import io.circe.generic.semiauto._

case class WindowsSecurityContextOptions(
  /* GMSACredentialSpec is where the GMSA admission webhook (https://github.com/kubernetes-sigs/windows-gmsa) inlines the contents of the GMSA credential spec named by the GMSACredentialSpecName field. */
  gmsaCredentialSpec: Option[String] = None,
  /* GMSACredentialSpecName is the name of the GMSA credential spec to use. */
  gmsaCredentialSpecName: Option[String] = None,
  /* The UserName in Windows to run the entrypoint of the container process. Defaults to the user specified in image metadata if unspecified. May also be set in PodSecurityContext. If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence. */
  runAsUserName: Option[String] = None
)

object WindowsSecurityContextOptions {
  implicit lazy val encoder: Encoder.AsObject[WindowsSecurityContextOptions] = deriveEncoder
  implicit lazy val decoder: Decoder[WindowsSecurityContextOptions] = deriveDecoder
}
