/*
 * Copyright 2022 Grabtaxi Holdings PTE LTD (GRAB)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.grab.grazel.migrate.android

import com.grab.grazel.bazel.starlark.BazelDependency

internal data class AndroidInstrumentationBinaryData(
    val associates: List<BazelDependency>,
    val customPackage: String,
    val debugKey: String? = null,
    val deps: List<BazelDependency>,
    val instruments: BazelDependency,
    val manifestValues: Map<String, String?> = mapOf(),
    val name: String,
    val resourceFiles: List<String>,
    val resources: List<String>,
    val srcs: List<String>,
    val testInstrumentationRunner: String? = null,
)
