/*
 * Decompiled with CFR 0.152.
 */
package com.grab.grazel.migrate.android;

import com.android.build.gradle.BaseExtension;
import com.android.build.gradle.api.BaseVariant;
import com.grab.grazel.GrazelExtension;
import com.grab.grazel.bazel.rules.AndroidRulesKt;
import com.grab.grazel.bazel.rules.Multidex;
import com.grab.grazel.bazel.starlark.BazelDependency;
import com.grab.grazel.gradle.AndroidVariantDataSource;
import com.grab.grazel.gradle.BuildVariantKt;
import com.grab.grazel.gradle.ProjectKt;
import com.grab.grazel.migrate.android.AndroidBinaryData;
import com.grab.grazel.migrate.android.AndroidBinaryDataExtractor;
import com.grab.grazel.migrate.android.AndroidLibraryData;
import com.grab.grazel.migrate.android.DefaultAndroidBinaryDataExtractor;
import com.grab.grazel.migrate.android.GoogleServicesKt;
import com.grab.grazel.migrate.android.KeyStoreExtractor;
import com.grab.grazel.migrate.android.ManifestValuesBuilder;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.gradle.api.Project;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.api.reflect.TypeOf;
import org.jetbrains.annotations.NotNull;

@Singleton
@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0001\u0018\u00002\u00020\u0001B'\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/grab/grazel/migrate/android/DefaultAndroidBinaryDataExtractor;", "Lcom/grab/grazel/migrate/android/AndroidBinaryDataExtractor;", "variantDataSource", "Lcom/grab/grazel/gradle/AndroidVariantDataSource;", "grazelExtension", "Lcom/grab/grazel/GrazelExtension;", "keyStoreExtractor", "Lcom/grab/grazel/migrate/android/KeyStoreExtractor;", "manifestValuesBuilder", "Lcom/grab/grazel/migrate/android/ManifestValuesBuilder;", "(Lcom/grab/grazel/gradle/AndroidVariantDataSource;Lcom/grab/grazel/GrazelExtension;Lcom/grab/grazel/migrate/android/KeyStoreExtractor;Lcom/grab/grazel/migrate/android/ManifestValuesBuilder;)V", "databindingDependencies", "", "Lcom/grab/grazel/bazel/starlark/BazelDependency;", "extract", "Lcom/grab/grazel/migrate/android/AndroidBinaryData;", "project", "Lorg/gradle/api/Project;", "variant", "Lcom/android/build/gradle/api/BaseVariant;", "androidLibraryData", "Lcom/grab/grazel/migrate/android/AndroidLibraryData;", "grazel-gradle-plugin"})
public final class DefaultAndroidBinaryDataExtractor
implements AndroidBinaryDataExtractor {
    private final List<BazelDependency> databindingDependencies;
    private final AndroidVariantDataSource variantDataSource;
    private final GrazelExtension grazelExtension;
    private final KeyStoreExtractor keyStoreExtractor;
    private final ManifestValuesBuilder manifestValuesBuilder;

    @Override
    @NotNull
    public AndroidBinaryData extract(@NotNull Project project, @NotNull BaseVariant variant, @NotNull AndroidLibraryData androidLibraryData) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
        Intrinsics.checkNotNullParameter((Object)androidLibraryData, (String)"androidLibraryData");
        ExtensionContainer extensionContainer = project.getExtensions();
        Intrinsics.checkNotNullExpressionValue((Object)extensionContainer, (String)"project.extensions");
        ExtensionContainer $this$getByType$iv = extensionContainer;
        boolean $i$f$getByType = false;
        boolean $i$f$typeOf = false;
        Object object = $this$getByType$iv.getByType((TypeOf)new TypeOf<BaseExtension>(){});
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getByType(typeOf<T>())");
        BaseExtension extension = (BaseExtension)object;
        Map<String, String> manifestValues = this.manifestValuesBuilder.build(project, variant, extension.getDefaultConfig(), androidLibraryData.getPackageName());
        boolean multidexEnabled = Intrinsics.areEqual((Object)extension.getDefaultConfig().getMultiDexEnabled(), (Object)true) || this.grazelExtension.getAndroid().getMultiDexEnabled();
        Multidex multidex = multidexEnabled ? Multidex.Native : Multidex.Off;
        Integer dexShards = multidexEnabled ? this.grazelExtension.getAndroid().getDexShards() : null;
        String googleServicesJson = ProjectKt.getHasGooglePlayServicesPlugin(project) ? GoogleServicesKt.findGoogleServicesJson(BuildVariantKt.getMigratableBuildVariants(this.variantDataSource, project), project) : null;
        String buildId = ProjectKt.getHasGooglePlayServicesPlugin(project) && ProjectKt.getHasCrashlytics(project) ? this.grazelExtension.getRules().getGoogleServices().getCrashlytics().getBuildId() : null;
        List<BazelDependency> deps = ProjectKt.getHasDatabinding(project) ? this.databindingDependencies : CollectionsKt.emptyList();
        Project project2 = project.getRootProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project.rootProject");
        String debugKey = this.keyStoreExtractor.extract(project2, (BaseVariant)CollectionsKt.firstOrNull(BuildVariantKt.getMigratableBuildVariants(this.variantDataSource, project)));
        String string = project.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"project.name");
        return new AndroidBinaryData(string, manifestValues, deps, multidex, dexShards, this.grazelExtension.getAndroid().getIncrementalDexing(), debugKey, buildId, googleServicesJson, ProjectKt.getHasCrashlytics(project), ProjectKt.getHasDatabinding(project));
    }

    @Inject
    public DefaultAndroidBinaryDataExtractor(@NotNull AndroidVariantDataSource variantDataSource, @NotNull GrazelExtension grazelExtension, @NotNull KeyStoreExtractor keyStoreExtractor, @NotNull ManifestValuesBuilder manifestValuesBuilder) {
        Intrinsics.checkNotNullParameter((Object)variantDataSource, (String)"variantDataSource");
        Intrinsics.checkNotNullParameter((Object)grazelExtension, (String)"grazelExtension");
        Intrinsics.checkNotNullParameter((Object)keyStoreExtractor, (String)"keyStoreExtractor");
        Intrinsics.checkNotNullParameter((Object)manifestValuesBuilder, (String)"manifestValuesBuilder");
        this.variantDataSource = variantDataSource;
        this.grazelExtension = grazelExtension;
        this.keyStoreExtractor = keyStoreExtractor;
        this.manifestValuesBuilder = manifestValuesBuilder;
        this.databindingDependencies = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)AndroidRulesKt.getDATABINDING_ARTIFACTS()), (Function1)databindingDependencies.1.INSTANCE), (Function1)databindingDependencies.2.INSTANCE));
    }
}

