/*
 * Decompiled with CFR 0.152.
 */
package com.grab.grazel.migrate.builder;

import com.grab.grazel.extension.KotlinExtension;
import com.grab.grazel.extension.TestExtension;
import com.grab.grazel.gradle.ProjectKt;
import com.grab.grazel.migrate.BazelBuildTarget;
import com.grab.grazel.migrate.BazelTarget;
import com.grab.grazel.migrate.TargetBuilder;
import com.grab.grazel.migrate.builder.KtLibTargetBuilderKt;
import com.grab.grazel.migrate.kotlin.KotlinProjectData;
import com.grab.grazel.migrate.kotlin.KotlinProjectDataExtractor;
import com.grab.grazel.migrate.kotlin.KotlinUnitTestDataExtractor;
import com.grab.grazel.migrate.kotlin.KtLibraryTarget;
import com.grab.grazel.migrate.kotlin.UnitTestDataKt;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;

@Singleton
@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0001\u0018\u00002\u00020\u0001B'\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/grab/grazel/migrate/builder/KtLibTargetBuilder;", "Lcom/grab/grazel/migrate/TargetBuilder;", "projectDataExtractor", "Lcom/grab/grazel/migrate/kotlin/KotlinProjectDataExtractor;", "kotlinUnitTestDataExtractor", "Lcom/grab/grazel/migrate/kotlin/KotlinUnitTestDataExtractor;", "kotlinExtension", "Lcom/grab/grazel/extension/KotlinExtension;", "testExtension", "Lcom/grab/grazel/extension/TestExtension;", "(Lcom/grab/grazel/migrate/kotlin/KotlinProjectDataExtractor;Lcom/grab/grazel/migrate/kotlin/KotlinUnitTestDataExtractor;Lcom/grab/grazel/extension/KotlinExtension;Lcom/grab/grazel/extension/TestExtension;)V", "build", "", "Lcom/grab/grazel/migrate/BazelTarget;", "project", "Lorg/gradle/api/Project;", "canHandle", "", "grazel-gradle-plugin"})
public final class KtLibTargetBuilder
implements TargetBuilder {
    private final KotlinProjectDataExtractor projectDataExtractor;
    private final KotlinUnitTestDataExtractor kotlinUnitTestDataExtractor;
    private final KotlinExtension kotlinExtension;
    private final TestExtension testExtension;

    @Override
    @NotNull
    public List<BazelTarget> build(@NotNull Project project) {
        List list;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        KotlinProjectData projectData = this.projectDataExtractor.extract(project);
        KtLibraryTarget ktLibTargets = KtLibTargetBuilderKt.access$toKtLibraryTarget(projectData, this.kotlinExtension.getEnabledTransitiveReduction());
        if (this.testExtension.getEnableTestMigration()) {
            BazelBuildTarget unitTestsTargets = UnitTestDataKt.toUnitTestTarget(this.kotlinUnitTestDataExtractor.extract(project));
            list = CollectionsKt.listOf((Object[])new BazelBuildTarget[]{ktLibTargets, unitTestsTargets});
        } else {
            list = CollectionsKt.listOf((Object)ktLibTargets);
        }
        return list;
    }

    @Override
    public boolean canHandle(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Project $this$with = project;
        boolean bl = false;
        return !ProjectKt.isAndroid($this$with) && ProjectKt.isKotlin($this$with);
    }

    @Inject
    public KtLibTargetBuilder(@NotNull KotlinProjectDataExtractor projectDataExtractor, @NotNull KotlinUnitTestDataExtractor kotlinUnitTestDataExtractor, @NotNull KotlinExtension kotlinExtension, @NotNull TestExtension testExtension) {
        Intrinsics.checkNotNullParameter((Object)projectDataExtractor, (String)"projectDataExtractor");
        Intrinsics.checkNotNullParameter((Object)kotlinUnitTestDataExtractor, (String)"kotlinUnitTestDataExtractor");
        Intrinsics.checkNotNullParameter((Object)kotlinExtension, (String)"kotlinExtension");
        Intrinsics.checkNotNullParameter((Object)testExtension, (String)"testExtension");
        this.projectDataExtractor = projectDataExtractor;
        this.kotlinUnitTestDataExtractor = kotlinUnitTestDataExtractor;
        this.kotlinExtension = kotlinExtension;
        this.testExtension = testExtension;
    }
}

