/*
 * Decompiled with CFR 0.152.
 */
package com.grab.grazel.migrate.dependencies;

import com.grab.grazel.di.qualifiers.RootProject;
import com.grab.grazel.extension.ArtifactPinning;
import com.grab.grazel.extension.MavenInstallExtension;
import com.grab.grazel.hybrid.HybridKt;
import com.grab.grazel.migrate.dependencies.ArtifactsPinner;
import com.grab.grazel.migrate.dependencies.MavenPinningError;
import com.grab.grazel.migrate.dependencies.MavenPinningOutputStream;
import com.grab.grazel.migrate.dependencies.MavenTargets;
import com.grab.grazel.util.AnsiKt;
import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.gradle.api.logging.Logger;
import org.gradle.process.ExecResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Singleton
@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0001\u0018\u00002\u00020\u0001B\u0019\b\u0007\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\r\u0010\u000f\u001a\u00020\u0010H\u0000\u00a2\u0006\u0002\b\u0011J\n\u0010\u0012\u001a\u0004\u0018\u00010\u0010H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u0014\u0010\u0007\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\rR\u0014\u0010\u000e\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/grab/grazel/migrate/dependencies/DefaultArtifactsPinner;", "Lcom/grab/grazel/migrate/dependencies/ArtifactsPinner;", "rootProject", "Lorg/gradle/api/Project;", "mavenInstallExtension", "Lcom/grab/grazel/extension/MavenInstallExtension;", "(Lorg/gradle/api/Project;Lcom/grab/grazel/extension/MavenInstallExtension;)V", "artifactPinning", "Lcom/grab/grazel/extension/ArtifactPinning;", "getArtifactPinning", "()Lcom/grab/grazel/extension/ArtifactPinning;", "isEnabled", "", "()Z", "isMavenInstallJsonExists", "determinePinningTarget", "", "determinePinningTarget$grazel_gradle_plugin", "mavenInstallJson", "pin", "", "workspaceFile", "Ljava/io/File;", "grazel-gradle-plugin"})
public final class DefaultArtifactsPinner
implements ArtifactsPinner {
    private final Project rootProject;
    private final MavenInstallExtension mavenInstallExtension;

    private final ArtifactPinning getArtifactPinning() {
        return this.mavenInstallExtension.getArtifactPinning();
    }

    @Override
    public boolean isEnabled() {
        Object object = this.mavenInstallExtension.getArtifactPinning().getEnabled().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"mavenInstallExtension.ar\u2026factPinning.enabled.get()");
        return (Boolean)object;
    }

    private final boolean isMavenInstallJsonExists() {
        return this.rootProject.file((Object)this.getArtifactPinning().getMavenInstallJson()).exists();
    }

    @Override
    @Nullable
    public String mavenInstallJson() {
        return this.isMavenInstallJsonExists() ? "//:" + this.getArtifactPinning().getMavenInstallJson() : null;
    }

    @NotNull
    public final String determinePinningTarget$grazel_gradle_plugin() {
        return this.isMavenInstallJsonExists() ? MavenTargets.Unpinned.getTargetName() : MavenTargets.Pinned.getTargetName();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void pin(@NotNull File workspaceFile) {
        boolean bl;
        boolean $i$f$any;
        Iterable $this$any$iv;
        List errors;
        Object object;
        ExecResult firstRunResult;
        block10: {
            void $this$onEach$iv;
            Intrinsics.checkNotNullParameter((Object)workspaceFile, (String)"workspaceFile");
            if (!this.isEnabled()) return;
            Logger logger = this.rootProject.getLogger();
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"rootProject.logger");
            MavenPinningOutputStream outputStream = new MavenPinningOutputStream(logger);
            firstRunResult = HybridKt.bazelCommand$default(this.rootProject, "run", new String[]{this.determinePinningTarget$grazel_gradle_plugin(), "--noshow_progress"}, true, null, outputStream, 8, null);
            object = outputStream.getErrors$grazel_gradle_plugin();
            boolean $i$f$onEach = false;
            Iterator iterator = $this$onEach$iv;
            void $this$onEach_u24lambda_u2d16$iv = iterator;
            boolean bl2 = false;
            for (Object element$iv : $this$onEach_u24lambda_u2d16$iv) {
                MavenPinningError error = (MavenPinningError)element$iv;
                boolean bl3 = false;
                this.rootProject.getLogger().quiet(error.getMessage());
            }
            errors = (List)((Object)iterator);
            $this$any$iv = errors;
            $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    MavenPinningError it = (MavenPinningError)element$iv;
                    boolean bl4 = false;
                    if (!(it instanceof MavenPinningError.InvalidSignature)) continue;
                    bl = true;
                    break block10;
                }
                bl = false;
            }
        }
        if (!bl) {
            boolean bl5;
            block11: {
                $this$any$iv = errors;
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl5 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        MavenPinningError it = (MavenPinningError)element$iv;
                        boolean bl6 = false;
                        if (!(it instanceof MavenPinningError.JsonCorrupted)) continue;
                        bl5 = true;
                        break block11;
                    }
                    bl5 = false;
                }
            }
            if (!bl5) {
                if (firstRunResult.getExitValue() == 0) return;
                object = "Artifact pinning failed, please see the logs for details";
                throw new IllegalStateException(object.toString());
            }
        }
        this.rootProject.getLogger().quiet(AnsiKt.getAnsiYellow("\nRetrying pinning to fix " + this.getArtifactPinning().getMavenInstallJson()));
        String updatedWorkSpace = StringsKt.replace$default((String)FilesKt.readText$default((File)workspaceFile, null, (int)1, null), (String)"maven_install_json", (String)"#maven_install_json", (boolean)false, (int)4, null);
        FilesKt.writeText$default((File)workspaceFile, (String)updatedWorkSpace, null, (int)2, null);
        HybridKt.bazelCommand$default(this.rootProject, "run", new String[]{MavenTargets.Pinned.getTargetName(), "--noshow_progress"}, false, null, null, 28, null);
        FilesKt.writeText$default((File)workspaceFile, (String)StringsKt.replace$default((String)updatedWorkSpace, (String)"#maven_install_json", (String)"maven_install_json", (boolean)false, (int)4, null), null, (int)2, null);
    }

    @Inject
    public DefaultArtifactsPinner(@RootProject @NotNull Project rootProject, @NotNull MavenInstallExtension mavenInstallExtension) {
        Intrinsics.checkNotNullParameter((Object)rootProject, (String)"rootProject");
        Intrinsics.checkNotNullParameter((Object)mavenInstallExtension, (String)"mavenInstallExtension");
        this.rootProject = rootProject;
        this.mavenInstallExtension = mavenInstallExtension;
    }
}

