/*
 * Decompiled with CFR 0.152.
 */
package com.grab.grazel.tasks.internal;

import com.grab.grazel.bazel.starlark.Statement;
import com.grab.grazel.bazel.starlark.StatementKt;
import com.grab.grazel.di.GrazelComponent;
import com.grab.grazel.gradle.MigrationChecker;
import com.grab.grazel.gradle.ProjectKt;
import com.grab.grazel.migrate.internal.ProjectBazelFileBuilder;
import com.grab.grazel.tasks.internal.GenerateBazelScriptsTask;
import com.grab.grazel.util.AnsiKt;
import dagger.Lazy;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.internal.logging.progress.ProgressLogger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0010\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B1\b\u0007\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0003\u00a2\u0006\u0002\u0010\tJ\b\u0010\u000e\u001a\u00020\u000fH\u0007R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0011"}, d2={"Lcom/grab/grazel/tasks/internal/GenerateBazelScriptsTask;", "Lorg/gradle/api/DefaultTask;", "migrationChecker", "Ldagger/Lazy;", "Lcom/grab/grazel/gradle/MigrationChecker;", "bazelFileBuilder", "Lcom/grab/grazel/migrate/internal/ProjectBazelFileBuilder$Factory;", "progressLogger", "Lorg/gradle/internal/logging/progress/ProgressLogger;", "(Ldagger/Lazy;Ldagger/Lazy;Ldagger/Lazy;)V", "rootProject", "Lorg/gradle/api/Project;", "getRootProject", "()Lorg/gradle/api/Project;", "action", "", "Companion", "grazel-gradle-plugin"})
public class GenerateBazelScriptsTask
extends DefaultTask {
    private final Lazy<MigrationChecker> migrationChecker;
    private final Lazy<ProjectBazelFileBuilder.Factory> bazelFileBuilder;
    private final Lazy<ProgressLogger> progressLogger;
    private static final String TASK_NAME = "generateBazelScripts";
    @NotNull
    public static final Companion Companion = new Companion(null);

    private final Project getRootProject() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        Project project2 = project.getRootProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project.rootProject");
        return project2;
    }

    @TaskAction
    public final void action() {
        File file = this.getProject().file((Object)"BUILD.bazel");
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"project.file(BUILD_BAZEL)");
        File buildBazelFile = file;
        File file2 = this.getProject().file((Object)"BUILD.bazelignore");
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"project.file(BUILD_BAZEL_IGNORE)");
        File bazelIgnoreFile = file2;
        MigrationChecker migrationChecker = (MigrationChecker)this.migrationChecker.get();
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        if (migrationChecker.canMigrate(project)) {
            ProjectBazelFileBuilder.Factory factory = (ProjectBazelFileBuilder.Factory)this.bazelFileBuilder.get();
            Project project2 = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
            ProjectBazelFileBuilder projectBazelFileBuilder = factory.create(project2);
            List<Statement> content = projectBazelFileBuilder.build();
            Collection collection = content;
            if (!collection.isEmpty()) {
                StatementKt.writeToFile(content, buildBazelFile);
                String generatedMessage = "Generated " + this.getRootProject().relativePath((Object)buildBazelFile);
                ((ProgressLogger)this.progressLogger.get()).progress(generatedMessage);
                this.getLogger().quiet(AnsiKt.getAnsiGreen(generatedMessage));
                bazelIgnoreFile.delete();
            } else {
                buildBazelFile.delete();
                String deletedMessage = "Deleted " + this.getRootProject().relativePath((Object)buildBazelFile);
                ((ProgressLogger)this.progressLogger.get()).progress(AnsiKt.getAnsiGreen(deletedMessage));
                this.getLogger().quiet(deletedMessage);
            }
        } else {
            bazelIgnoreFile.delete();
            Project project3 = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"project");
            if (ProjectKt.isMigrated(project3) && buildBazelFile.renameTo(bazelIgnoreFile)) {
                Project project4 = this.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project4, (String)"project");
                project4.getLogger().quiet(AnsiKt.getAnsiYellow(buildBazelFile + " renamed to " + bazelIgnoreFile));
            }
        }
    }

    @Inject
    public GenerateBazelScriptsTask(@NotNull Lazy<MigrationChecker> migrationChecker, @NotNull Lazy<ProjectBazelFileBuilder.Factory> bazelFileBuilder, @NotNull Lazy<ProgressLogger> progressLogger) {
        Intrinsics.checkNotNullParameter(migrationChecker, (String)"migrationChecker");
        Intrinsics.checkNotNullParameter(bazelFileBuilder, (String)"bazelFileBuilder");
        Intrinsics.checkNotNullParameter(progressLogger, (String)"progressLogger");
        this.migrationChecker = migrationChecker;
        this.bazelFileBuilder = bazelFileBuilder;
        this.progressLogger = progressLogger;
        this.getOutputs().upToDateWhen((Spec)1.INSTANCE);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J>\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0019\b\u0002\u0010\f\u001a\u0013\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\u0002\b\u000fH\u0000\u00a2\u0006\u0002\b\u0010R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/grab/grazel/tasks/internal/GenerateBazelScriptsTask$Companion;", "", "()V", "TASK_NAME", "", "register", "Lorg/gradle/api/tasks/TaskProvider;", "Lcom/grab/grazel/tasks/internal/GenerateBazelScriptsTask;", "project", "Lorg/gradle/api/Project;", "grazelComponent", "Lcom/grab/grazel/di/GrazelComponent;", "configureAction", "Lkotlin/Function1;", "", "Lkotlin/ExtensionFunctionType;", "register$grazel_gradle_plugin", "grazel-gradle-plugin"})
    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        @NotNull
        public final TaskProvider<GenerateBazelScriptsTask> register$grazel_gradle_plugin(@NotNull Project project, @NotNull GrazelComponent grazelComponent, @NotNull Function1<? super GenerateBazelScriptsTask, Unit> configureAction) {
            void name$iv;
            void $this$register$iv;
            void arguments$iv;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)grazelComponent, (String)"grazelComponent");
            Intrinsics.checkNotNullParameter(configureAction, (String)"configureAction");
            TaskContainer taskContainer = project.getTasks();
            Intrinsics.checkNotNullExpressionValue((Object)taskContainer, (String)"project.tasks");
            TaskContainer taskContainer2 = taskContainer;
            String string = GenerateBazelScriptsTask.TASK_NAME;
            Object[] objectArray = new Object[]{grazelComponent.migrationChecker(), grazelComponent.projectBazelFileBuilderFactory(), grazelComponent.progressLogger()};
            boolean $i$f$register = false;
            void v1 = arguments$iv;
            TaskProvider taskProvider = $this$register$iv.register((String)name$iv, GenerateBazelScriptsTask.class, (Object[])Arrays.copyOf(v1, ((void)v1).length));
            Intrinsics.checkNotNullExpressionValue((Object)taskProvider, (String)"register(name, T::class.java, *arguments)");
            TaskContainer $this$apply = taskContainer2 = taskProvider;
            boolean bl = false;
            $this$apply.configure(new Action(configureAction){
                final /* synthetic */ Function1 $configureAction$inlined;
                {
                    this.$configureAction$inlined = function1;
                }

                public final void execute(@NotNull GenerateBazelScriptsTask $this$configure) {
                    Intrinsics.checkNotNullParameter((Object)((Object)$this$configure), (String)"$receiver");
                    $this$configure.setGroup("bazel");
                    $this$configure.setDescription("Generate BUILD.bazel for this project");
                    this.$configureAction$inlined.invoke((Object)((Object)$this$configure));
                }
            });
            TaskContainer genTask = taskContainer2;
            return genTask;
        }

        public static /* synthetic */ TaskProvider register$grazel_gradle_plugin$default(Companion companion, Project project, GrazelComponent grazelComponent, Function1 function1, int n, Object object) {
            if ((n & 4) != 0) {
                function1 = register.1.INSTANCE;
            }
            return companion.register$grazel_gradle_plugin(project, grazelComponent, (Function1<? super GenerateBazelScriptsTask, Unit>)function1);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

