/*
 * Decompiled with CFR 0.152.
 */
package com.grab.grazel.tasks.internal;

import com.grab.grazel.bazel.starlark.Statement;
import com.grab.grazel.bazel.starlark.StatementKt;
import com.grab.grazel.di.GrazelComponent;
import com.grab.grazel.di.qualifiers.RootProject;
import com.grab.grazel.gradle.MigrationChecker;
import com.grab.grazel.migrate.internal.RootBazelFileBuilder;
import com.grab.grazel.migrate.internal.WorkspaceBuilder;
import com.grab.grazel.tasks.internal.GenerateRootBazelScriptsTask;
import com.grab.grazel.util.AnsiKt;
import dagger.Lazy;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0010\u0018\u0000 \f2\u00020\u0001:\u0001\fB1\b\u0007\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0003\u00a2\u0006\u0002\u0010\tJ\b\u0010\n\u001a\u00020\u000bH\u0007R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/grab/grazel/tasks/internal/GenerateRootBazelScriptsTask;", "Lorg/gradle/api/DefaultTask;", "migrationChecker", "Ldagger/Lazy;", "Lcom/grab/grazel/gradle/MigrationChecker;", "workspaceBuilderFactory", "Lcom/grab/grazel/migrate/internal/WorkspaceBuilder$Factory;", "rootBazelBuilder", "Lcom/grab/grazel/migrate/internal/RootBazelFileBuilder;", "(Ldagger/Lazy;Ldagger/Lazy;Ldagger/Lazy;)V", "action", "", "Companion", "grazel-gradle-plugin"})
public class GenerateRootBazelScriptsTask
extends DefaultTask {
    private final Lazy<MigrationChecker> migrationChecker;
    private final Lazy<WorkspaceBuilder.Factory> workspaceBuilderFactory;
    private final Lazy<RootBazelFileBuilder> rootBazelBuilder;
    private static final String TASK_NAME = "generateRootBazelScripts";
    @NotNull
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - void declaration
     */
    @TaskAction
    public final void action() {
        void $this$filterTo$iv$iv;
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        Project project2 = project.getRootProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project.rootProject");
        Project rootProject = project2;
        Set set = rootProject.getSubprojects();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"rootProject\n            .subprojects");
        Iterable $this$filter$iv = set;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Project it = (Project)element$iv$iv;
            boolean bl = false;
            MigrationChecker migrationChecker = (MigrationChecker)this.migrationChecker.get();
            Project project3 = it;
            Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"it");
            if (!migrationChecker.canMigrate(project3)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List projectsToMigrate = (List)destination$iv$iv;
        List<Statement> list = ((WorkspaceBuilder.Factory)this.workspaceBuilderFactory.get()).create(projectsToMigrate).build();
        File file = rootProject.file((Object)"WORKSPACE");
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"rootProject.file(WORKSPACE)");
        StatementKt.writeToFile(list, file);
        this.getLogger().quiet(AnsiKt.getAnsiGreen("Generated WORKSPACE"));
        List<Statement> rootBuildBazelContents = ((RootBazelFileBuilder)this.rootBazelBuilder.get()).build();
        Collection collection = rootBuildBazelContents;
        if (!collection.isEmpty()) {
            File file2 = rootProject.file((Object)"BUILD.bazel");
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"rootProject.file(BUILD_BAZEL)");
            StatementKt.writeToFile(rootBuildBazelContents, file2);
            this.getLogger().quiet(AnsiKt.getAnsiGreen("Generated BUILD.bazel"));
        }
    }

    @Inject
    public GenerateRootBazelScriptsTask(@NotNull Lazy<MigrationChecker> migrationChecker, @NotNull Lazy<WorkspaceBuilder.Factory> workspaceBuilderFactory, @NotNull Lazy<RootBazelFileBuilder> rootBazelBuilder) {
        Intrinsics.checkNotNullParameter(migrationChecker, (String)"migrationChecker");
        Intrinsics.checkNotNullParameter(workspaceBuilderFactory, (String)"workspaceBuilderFactory");
        Intrinsics.checkNotNullParameter(rootBazelBuilder, (String)"rootBazelBuilder");
        this.migrationChecker = migrationChecker;
        this.workspaceBuilderFactory = workspaceBuilderFactory;
        this.rootBazelBuilder = rootBazelBuilder;
        this.getOutputs().upToDateWhen((Spec)1.INSTANCE);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\b\b\u0001\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/grab/grazel/tasks/internal/GenerateRootBazelScriptsTask$Companion;", "", "()V", "TASK_NAME", "", "register", "Lorg/gradle/api/tasks/TaskProvider;", "Lcom/grab/grazel/tasks/internal/GenerateRootBazelScriptsTask;", "rootProject", "Lorg/gradle/api/Project;", "grazelComponent", "Lcom/grab/grazel/di/GrazelComponent;", "grazel-gradle-plugin"})
    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        @NotNull
        public final TaskProvider<GenerateRootBazelScriptsTask> register(@RootProject @NotNull Project rootProject, @NotNull GrazelComponent grazelComponent) {
            void name$iv;
            void $this$register$iv;
            void arguments$iv;
            Intrinsics.checkNotNullParameter((Object)rootProject, (String)"rootProject");
            Intrinsics.checkNotNullParameter((Object)grazelComponent, (String)"grazelComponent");
            TaskContainer taskContainer = rootProject.getTasks();
            Intrinsics.checkNotNullExpressionValue((Object)taskContainer, (String)"rootProject.tasks");
            TaskContainer taskContainer2 = taskContainer;
            String string = GenerateRootBazelScriptsTask.TASK_NAME;
            Object[] objectArray = new Object[]{grazelComponent.migrationChecker(), grazelComponent.workspaceBuilderFactory(), grazelComponent.rootBazelFileBuilder()};
            boolean $i$f$register = false;
            void v1 = arguments$iv;
            TaskProvider taskProvider = $this$register$iv.register((String)name$iv, GenerateRootBazelScriptsTask.class, (Object[])Arrays.copyOf(v1, ((void)v1).length));
            Intrinsics.checkNotNullExpressionValue((Object)taskProvider, (String)"register(name, T::class.java, *arguments)");
            TaskContainer $this$apply = taskContainer2 = taskProvider;
            boolean bl = false;
            $this$apply.configure((Action)register.1.1.INSTANCE);
            return taskContainer2;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

