/*
 * Decompiled with CFR 0.152.
 */
package com.grack.nanojson;

import com.grack.nanojson.JsonAppendableWriter;
import com.grack.nanojson.JsonStringWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.nio.charset.Charset;

public final class JsonWriter {
    private JsonWriter() {
    }

    public static JsonWriterContext indent(String string) {
        if (string == null) {
            throw new IllegalArgumentException("indent must be non-null");
        }
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == ' ' || string.charAt(i) == '\t') continue;
            throw new IllegalArgumentException("Only tabs and spaces are allowed for indent.");
        }
        return new JsonWriterContext(string);
    }

    public static JsonStringWriter string() {
        return new JsonStringWriter(null);
    }

    public static String string(Object object) {
        return ((JsonStringWriter)new JsonStringWriter(null).value(object)).done();
    }

    public static JsonAppendableWriter on(Appendable appendable) {
        return new JsonAppendableWriter(appendable, null);
    }

    public static JsonAppendableWriter on(PrintStream printStream) {
        return new JsonAppendableWriter(printStream, null);
    }

    public static JsonAppendableWriter on(OutputStream outputStream) {
        return new JsonAppendableWriter(outputStream, null);
    }

    public static String escape(String string) {
        String string2 = JsonWriter.string(string);
        return string2.substring(1, string2.length() - 1);
    }

    public static final class JsonWriterContext {
        private String indent;

        private JsonWriterContext(String string) {
            this.indent = string;
        }

        public JsonStringWriter string() {
            return new JsonStringWriter(this.indent);
        }

        public JsonAppendableWriter on(Appendable appendable) {
            return new JsonAppendableWriter(appendable, this.indent);
        }

        public JsonAppendableWriter on(PrintStream printStream) {
            return new JsonAppendableWriter(printStream, this.indent);
        }

        public JsonAppendableWriter on(OutputStream outputStream) {
            return new JsonAppendableWriter(new OutputStreamWriter(outputStream, Charset.forName("UTF-8")), this.indent);
        }
    }
}

