/*
 * Decompiled with CFR 0.152.
 */
package com.gradecak.alfresco.mvc.aop;

import com.gradecak.alfresco.mvc.annotation.AlfrescoTransaction;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.ServiceRegistry;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.core.BridgeMethodResolver;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.util.ClassUtils;

public class TransactionalAdvice
implements MethodInterceptor {
    private final ServiceRegistry serviceRegistry;

    public TransactionalAdvice(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    public Object invoke(final MethodInvocation invocation) throws Throwable {
        Class<?> targetClass = invocation.getThis() != null ? invocation.getThis().getClass() : null;
        Method specificMethod = ClassUtils.getMostSpecificMethod((Method)invocation.getMethod(), targetClass);
        AlfrescoTransaction alfrescoTransaction = this.parseAnnotation(specificMethod = BridgeMethodResolver.findBridgedMethod((Method)specificMethod));
        if (alfrescoTransaction != null) {
            RetryingTransactionHelper.RetryingTransactionCallback<Object> exampleWork = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

                public Object execute() throws Throwable {
                    return invocation.proceed();
                }
            };
            boolean readonly = alfrescoTransaction.readOnly();
            Propagation propagation = alfrescoTransaction.propagation();
            boolean requiresNew = Propagation.REQUIRES_NEW.equals((Object)propagation);
            return this.serviceRegistry.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)exampleWork, readonly, requiresNew);
        }
        return invocation.proceed();
    }

    private AlfrescoTransaction parseAnnotation(AnnotatedElement ae) {
        AlfrescoTransaction ann = ae.getAnnotation(AlfrescoTransaction.class);
        if (ann == null) {
            Annotation metaAnn;
            Annotation[] annotationArray = ae.getAnnotations();
            int n = annotationArray.length;
            for (int i = 0; i < n && (ann = (metaAnn = annotationArray[i]).annotationType().getAnnotation(AlfrescoTransaction.class)) == null; ++i) {
            }
        }
        if (ann != null) {
            return this.parseAnnotation(ann);
        }
        return null;
    }

    private AlfrescoTransaction parseAnnotation(AlfrescoTransaction ann) {
        return ann;
    }
}

