/*
 * Decompiled with CFR 0.152.
 */
package com.gradecak.alfresco.mvc.rest;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;

public class ResponseMapBuilder {
    private final ImmutableMap.Builder<String, Object> variables = ImmutableMap.builder();

    public ResponseMapBuilder withData(Object data) {
        int size = 1;
        if (data != null && data instanceof List) {
            size = ((List)data).size();
        }
        return this.withEntry("data", data).withEntry("total", size);
    }

    public ResponseMapBuilder withSuccess(boolean success) {
        return this.withEntry("success", success);
    }

    public ResponseMapBuilder withEntry(String key, Object value) {
        if (value != null) {
            this.variables.put((Object)key, value);
        }
        return this;
    }

    public Map<String, Object> build() {
        return this.variables.build();
    }

    public static ResponseMapBuilder createSuccessResponseMap() {
        return new ResponseMapBuilder().withSuccess(true);
    }

    public static ResponseMapBuilder createFailResponseMap() {
        return new ResponseMapBuilder().withSuccess(false);
    }

    public static ResponseMapBuilder createResponseMap(Object data, boolean success) {
        return new ResponseMapBuilder().withData(data).withSuccess(success);
    }

    public static ResponseMapBuilder createResponseMap(String key, Object value) {
        return new ResponseMapBuilder().withEntry(key, value);
    }
}

