/*
 * Decompiled with CFR 0.152.
 */
package com.gradecak.alfresco.mvc.rest.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.springframework.core.convert.converter.Converter;

public class Jackson2QnameDeserializer
extends JsonDeserializer<QName>
implements Converter<String, QName> {
    private ServiceRegistry serviceRegistry;

    public Jackson2QnameDeserializer(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    public QName deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        String qname = jp.getText();
        return QName.createQName((String)qname, (NamespacePrefixResolver)this.serviceRegistry.getNamespaceService());
    }

    public QName convert(String qname) {
        return QName.createQName((String)qname, (NamespacePrefixResolver)this.serviceRegistry.getNamespaceService());
    }
}

