/*
 * Decompiled with CFR 0.152.
 */
package com.gradecak.alfresco.mvc.webscript;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.env.AbstractEnvironment;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.extensions.webscripts.AbstractWebScript;
import org.springframework.extensions.webscripts.WebScriptRequest;
import org.springframework.extensions.webscripts.WebScriptResponse;
import org.springframework.extensions.webscripts.WrappingWebScriptResponse;
import org.springframework.extensions.webscripts.servlet.WebScriptServletRequest;
import org.springframework.extensions.webscripts.servlet.WebScriptServletResponse;
import org.springframework.util.Assert;
import org.springframework.web.context.ConfigurableWebApplicationContext;
import org.springframework.web.context.ServletContextAware;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.servlet.DispatcherServlet;

public class DispatcherWebscript
extends AbstractWebScript
implements ApplicationListener<ContextRefreshedEvent>,
ServletContextAware,
ApplicationContextAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(DispatcherWebscript.class);
    private static final int EXTENSION_PATH_REGEXP_GROUP_INDEX = 3;
    protected DispatcherServlet s;
    private String contextConfigLocation;
    private Class<?> contextClass;
    private ApplicationContext applicationContext;
    private ServletContext servletContext;
    private final EnumSet<ServletConfigOptions> servletConfigOptions = EnumSet.noneOf(ServletConfigOptions.class);
    private final String servletName;
    private final boolean inheritGlobalProperties;

    public DispatcherWebscript() {
        this("alfresco-mvc.mvc", false);
    }

    public DispatcherWebscript(String servletName) {
        this(servletName, false);
    }

    public DispatcherWebscript(String servletName, boolean inheritGlobalProperties) {
        Assert.hasText((String)servletName, (String)"[Assertion failed] - this String servletName must have text; it must not be null, empty, or blank");
        this.servletName = servletName;
        this.inheritGlobalProperties = inheritGlobalProperties;
    }

    public void execute(WebScriptRequest req, WebScriptResponse res) throws IOException {
        WebScriptServletRequest origReq = (WebScriptServletRequest)req;
        WebScriptServletResponse wsr = null;
        wsr = res instanceof WrappingWebScriptResponse ? (WebScriptServletResponse)((WrappingWebScriptResponse)res).getNext() : (WebScriptServletResponse)res;
        HttpServletResponse sr = wsr.getHttpServletResponse();
        res.setHeader("Cache-Control", "no-cache");
        WebscriptRequestWrapper wrapper = new WebscriptRequestWrapper(origReq);
        try {
            this.s.service((ServletRequest)wrapper, (ServletResponse)sr);
        }
        catch (Throwable e) {
            throw new IOException(e);
        }
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        ApplicationContext refreshContext = event.getApplicationContext();
        if (refreshContext != null && refreshContext.equals(this.applicationContext)) {
            this.s = new DispatcherServlet(){
                private static final long serialVersionUID = -7492692694742840997L;

                protected WebApplicationContext initWebApplicationContext() {
                    WebApplicationContext wac = this.createWebApplicationContext(DispatcherWebscript.this.applicationContext);
                    if (wac == null) {
                        wac = super.initWebApplicationContext();
                    }
                    return wac;
                }

                protected void postProcessWebApplicationContext(ConfigurableWebApplicationContext wac) {
                    wac.addBeanFactoryPostProcessor(new BeanFactoryPostProcessor(){

                        public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
                            if (!beanFactory.containsBean("dispatcherServlet")) {
                                AbstractBeanDefinition beanDefinition = BeanDefinitionBuilder.genericBeanDefinition(DispatcherServlet.class).getBeanDefinition();
                                beanDefinition.setInstanceSupplier(() -> DispatcherWebscript.this.getDispatcherServlet());
                                beanDefinition.setPrimary(true);
                                ((BeanDefinitionRegistry)beanFactory).registerBeanDefinition("dispatcherServlet", (BeanDefinition)beanDefinition);
                            }
                        }
                    });
                }
            };
            if (!this.servletConfigOptions.isEmpty()) {
                this.s.setDetectAllHandlerMappings(!this.servletConfigOptions.contains((Object)ServletConfigOptions.DISABLED_PARENT_HANDLER_MAPPINGS));
                this.s.setDetectAllHandlerAdapters(!this.servletConfigOptions.contains((Object)ServletConfigOptions.DISABLED_PARENT_HANDLER_ADAPTERS));
                this.s.setDetectAllViewResolvers(!this.servletConfigOptions.contains((Object)ServletConfigOptions.DISABLED_PARENT_VIEW_RESOLVERS));
                this.s.setDetectAllHandlerExceptionResolvers(!this.servletConfigOptions.contains((Object)ServletConfigOptions.DISABLED_PARENT_HANDLER_EXCEPTION_RESOLVERS));
            }
            if (this.contextClass != null) {
                this.s.setContextClass(this.contextClass);
            }
            this.s.setContextConfigLocation(this.contextConfigLocation);
            this.configureDispatcherServlet(this.s);
            try {
                this.s.init((ServletConfig)new DelegatingServletConfig(this.servletName));
                LOGGER.info("Alfresco @MVC Dispatcher Webscript: {} has been started", (Object)this.servletName);
            }
            catch (ServletException e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected void configureDispatcherServlet(DispatcherServlet dispatcherServlet) {
        if (this.inheritGlobalProperties) {
            final Properties globalProperties = (Properties)this.applicationContext.getBean("global-properties");
            ConfigurableEnvironment servletEnv = dispatcherServlet.getEnvironment();
            servletEnv.merge((ConfigurableEnvironment)new AbstractEnvironment(){

                public MutablePropertySources getPropertySources() {
                    MutablePropertySources mutablePropertySources = new MutablePropertySources();
                    mutablePropertySources.addFirst((PropertySource)new PropertiesPropertySource("alfresco-global.properties", globalProperties));
                    return mutablePropertySources;
                }
            });
        }
    }

    public DispatcherServlet getDispatcherServlet() {
        return this.s;
    }

    public String getContextConfigLocation() {
        return this.contextConfigLocation;
    }

    public void setContextConfigLocation(String contextConfigLocation) {
        this.contextConfigLocation = contextConfigLocation;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public void setContextClass(Class<?> contextClass) {
        this.contextClass = contextClass;
    }

    public Class<?> getContextClass() {
        return this.contextClass;
    }

    public void addServletConfigOptions(ServletConfigOptions[] detectServletConfig) {
        if (detectServletConfig != null) {
            this.servletConfigOptions.addAll(Arrays.asList(detectServletConfig));
        }
    }

    public ServletConfigOptions[] getServletConfigOptions() {
        return this.servletConfigOptions.toArray(new ServletConfigOptions[0]);
    }

    public static enum ServletConfigOptions {
        DISABLED_PARENT_HANDLER_MAPPINGS,
        DISABLED_PARENT_HANDLER_ADAPTERS,
        DISABLED_PARENT_VIEW_RESOLVERS,
        DISABLED_PARENT_HANDLER_EXCEPTION_RESOLVERS;

    }

    public class WebscriptRequestWrapper
    extends HttpServletRequestWrapper {
        private WebScriptServletRequest origReq;

        public WebscriptRequestWrapper(WebScriptServletRequest request) {
            super(request.getHttpServletRequest());
            this.origReq = request;
        }

        public String getRequestURI() {
            Pattern pattern;
            Matcher matcher;
            String origUri;
            String uri = super.getRequestURI();
            if (uri.contains("$")) {
                uri = uri.replaceAll("\\$", "%24");
            }
            if ((origUri = this.origReq.getExtensionPath()).contains("$")) {
                origUri = origUri.replaceAll("\\$", "%24");
            }
            if ((matcher = (pattern = Pattern.compile("(^" + this.origReq.getServiceContextPath() + "/)(.*)(/" + origUri + ")")).matcher(uri)).find()) {
                try {
                    return matcher.group(3);
                }
                catch (Exception e) {
                    LOGGER.warn("no such group (3) in regexp while URI evaluation", (Throwable)e);
                }
            }
            return "";
        }

        public String getContextPath() {
            return this.origReq.getContextPath();
        }

        public String getServletPath() {
            return "";
        }

        public WebScriptServletRequest getWebScriptServletRequest() {
            return this.origReq;
        }
    }

    public class DelegatingServletConfig
    implements ServletConfig {
        private final String name;

        public DelegatingServletConfig(String name) {
            Assert.hasText((String)name, (String)"[Assertion failed] - this String name must have text; it must not be null, empty, or blank");
            this.name = name;
        }

        public String getServletName() {
            return this.name;
        }

        public ServletContext getServletContext() {
            return DispatcherWebscript.this.servletContext;
        }

        public String getInitParameter(String paramName) {
            return null;
        }

        public Enumeration<String> getInitParameterNames() {
            return Collections.enumeration(new HashSet());
        }
    }
}

