/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.develocity.agent.maven.adapters;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReflectionUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReflectionUtils.class);

    private ReflectionUtils() {
    }

    public static Object invokeMethod(Object obj, String method, Object ... args) {
        try {
            Optional<Method> maybeMethod = Arrays.stream(obj.getClass().getMethods()).filter(it -> it.getName().equals(method)).findFirst();
            if (maybeMethod.isPresent()) {
                return maybeMethod.get().invoke(obj, args);
            }
            ReflectionUtils.warnAboutUnsupportedMethod(method);
            return null;
        }
        catch (ReflectiveOperationException e) {
            ReflectionUtils.warnAboutUnsupportedMethod(method);
            return null;
        }
    }

    public static void withMethodSupported(Object obj, String method, Runnable action) {
        if (ReflectionUtils.isMethodSupported(obj, method)) {
            action.run();
        } else {
            ReflectionUtils.warnAboutUnsupportedMethod(method);
        }
    }

    private static boolean isMethodSupported(Object obj, String method) {
        return Arrays.stream(obj.getClass().getMethods()).anyMatch(it -> it.getName().equals(method));
    }

    private static void warnAboutUnsupportedMethod(String method) {
        LOGGER.warn("The '{}' method is not supported by this version of the Develocity extension", (Object)method);
    }
}

