/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.develocity.agent.gradle.adapters.develocity;

import com.gradle.develocity.agent.gradle.DevelocityConfiguration;
import com.gradle.develocity.agent.gradle.adapters.BuildScanAdapter;
import com.gradle.develocity.agent.gradle.adapters.DevelocityAdapter;
import com.gradle.develocity.agent.gradle.adapters.develocity.BuildScanConfigurationAdapter;
import com.gradle.develocity.agent.gradle.adapters.internal.AdapterTypeUtils;
import com.gradle.develocity.agent.gradle.adapters.internal.ProxyFactory;
import org.gradle.api.Action;
import org.gradle.caching.configuration.AbstractBuildCache;
import org.jetbrains.annotations.Nullable;

public class DevelocityConfigurationAdapter
implements DevelocityAdapter {
    private final DevelocityConfiguration configuration;
    private final BuildScanConfigurationAdapter buildScan;

    public DevelocityConfigurationAdapter(Object configuration) {
        AdapterTypeUtils.checkIsDevelocityConfiguration(configuration);
        this.configuration = ProxyFactory.createProxy(configuration, DevelocityConfiguration.class);
        this.buildScan = new BuildScanConfigurationAdapter(this.configuration.getBuildScan());
    }

    @Override
    public BuildScanAdapter getBuildScan() {
        return this.buildScan;
    }

    @Override
    public void buildScan(Action<? super BuildScanAdapter> action) {
        action.execute((Object)this.buildScan);
    }

    @Override
    public void setServer(@Nullable String server) {
        this.configuration.getServer().set((Object)server);
    }

    @Override
    @Nullable
    public String getServer() {
        return (String)this.configuration.getServer().getOrNull();
    }

    @Override
    public void setProjectId(@Nullable String projectId) {
        this.configuration.getProjectId().set((Object)projectId);
    }

    @Override
    @Nullable
    public String getProjectId() {
        return (String)this.configuration.getProjectId().getOrNull();
    }

    @Override
    public void setAllowUntrustedServer(boolean allow) {
        this.configuration.getAllowUntrustedServer().set((Object)allow);
    }

    @Override
    public boolean getAllowUntrustedServer() {
        return (Boolean)this.configuration.getAllowUntrustedServer().get();
    }

    @Override
    public void setAccessKey(@Nullable String accessKey) {
        this.configuration.getAccessKey().set((Object)accessKey);
    }

    @Override
    @Nullable
    public String getAccessKey() {
        return (String)this.configuration.getAccessKey().getOrNull();
    }

    @Override
    @Nullable
    public Class<? extends AbstractBuildCache> getBuildCache() {
        return this.configuration.getBuildCache();
    }
}

