/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.develocity.agent.gradle.adapters.internal;

import com.gradle.develocity.agent.gradle.adapters.internal.ReflectionUtils;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.gradle.api.provider.Property;

public class ReflectionProperty<T> {
    private final Supplier<T> getter;
    private final Consumer<T> setter;

    private ReflectionProperty(Supplier<T> getter, Consumer<T> setter) {
        this.getter = getter;
        this.setter = setter;
    }

    public static <T> ReflectionProperty<T> unsupported(final String getterName, final String setterName, final T defaultValue) {
        return new ReflectionProperty<T>(new Supplier<T>(){

            @Override
            public T get() {
                ReflectionUtils.warnAboutUnsupportedMethod(getterName);
                return defaultValue;
            }
        }, new Consumer<T>(){

            @Override
            public void accept(T value) {
                ReflectionUtils.warnAboutUnsupportedMethod(setterName);
            }
        });
    }

    public static <T> ReflectionProperty<T> forGetterAndSetter(Object obj, String getterName, String setterName) {
        return ReflectionProperty.forGetterAndSetter(obj, getterName, setterName, null);
    }

    public static <T> ReflectionProperty<T> forGetterAndSetter(final Object obj, final String getterName, final String setterName, final T defaultValue) {
        return new ReflectionProperty<T>(new Supplier<T>(){

            @Override
            public T get() {
                return ReflectionProperty.getIfSupported(obj, getterName, defaultValue);
            }
        }, new Consumer<T>(){

            @Override
            public void accept(T value) {
                ReflectionProperty.setIfSupported(obj, setterName, value);
            }
        });
    }

    public static <T> ReflectionProperty<T> forProperty(Object obj, String propertyName) {
        return ReflectionProperty.forProperty(obj, propertyName, null);
    }

    public static <T> ReflectionProperty<T> forProperty(final Object obj, final String propertyName, final T defaultValue) {
        return new ReflectionProperty<T>(new Supplier<T>(){

            @Override
            public T get() {
                Property prop = (Property)ReflectionUtils.invokeMethod(obj, propertyName, new Object[0]);
                return prop.getOrElse(defaultValue);
            }
        }, new Consumer<T>(){

            @Override
            public void accept(T value) {
                Property prop = (Property)ReflectionUtils.invokeMethod(obj, propertyName, new Object[0]);
                prop.set(value);
            }
        });
    }

    public void set(T value) {
        this.setter.accept(value);
    }

    public T get() {
        return this.getter.get();
    }

    private static <T> void setIfSupported(Object obj, String method, T value) {
        ReflectionUtils.invokeMethod(obj, method, value);
    }

    private static <T> T getIfSupported(Object obj, String method, T defaultValue) {
        Object rawValue = ReflectionUtils.invokeMethod(obj, method, new Object[0]);
        return (T)(rawValue == null ? defaultValue : rawValue);
    }
}

